
set serveroutput on
set echo on

conn sys/knl_test7 as sysdba
grant connect, resource , aq_administrator_role to scott identified by tiger
/
grant execute on dbms_aq to scott
/
grant execute on dbms_aqadm to scott 
/
grant execute on dbms_lock to scott
/
grant execute on dbms_streams_adm to scott
/

conn scott/tiger 

BEGIN 
	sys.dbms_aqadm.stop_queue(queue_name => 'scott.toy_queue'); 
	sys.dbms_aqadm.drop_queue(queue_name => 'scott.toy_queue'); 
	sys.dbms_aqadm.drop_queue_table (queue_table => 'scott.toy_queue_table');

	sys.dbms_aqadm.stop_queue(queue_name => 'scott.toy_topic'); 
	sys.dbms_aqadm.drop_queue(queue_name => 'scott.toy_topic'); 
	sys.dbms_aqadm.drop_queue_table (queue_table => 'scott.toy_topic_table');
END;
/
show errors

drop type scott.toy_type;

CREATE type scott.toy_type as object (
   name VARCHAR2(30),
   description  VARCHAR2(80));   
/
show errors

BEGIN 
	dbms_aqadm.create_queue_table (
	   queue_table            => 'scott.toy_queue_table',
	   queue_payload_type     => 'scott.toy_type');

	dbms_aqadm.create_queue( 
	queue_name  => 'scott.toy_queue', 
	queue_table => 'scott.toy_queue_table' );
	dbms_aqadm.start_queue(queue_name => 'scott.toy_queue');

	dbms_aqadm.create_queue_table (
	   queue_table            => 'scott.toy_topic_table',
           multiple_consumers => TRUE,
	   queue_payload_type     => 'scott.toy_type');

	dbms_aqadm.create_queue( 
	   queue_name  => 'scott.toy_topic', 
	   queue_table => 'scott.toy_topic_table' );
	   dbms_aqadm.start_queue(queue_name => 'scott.toy_topic');
END;
/
show errors

BEGIN 
	sys.dbms_aqadm.stop_queue(queue_name => 'scott.toy_stream');
	sys.dbms_aqadm.drop_queue(queue_name => 'scott.toy_stream');
	sys.dbms_aqadm.drop_queue_table(queue_table => 'scott.toy_stream_table');
END;
/
show errors

BEGIN
  DBMS_STREAMS_ADM.SET_UP_QUEUE( 
    queue_table => 'toy_stream_table', 
    queue_name  => 'toy_stream');
END;
/
show errors

exit;

DECLARE
   Enqueue_options       dbms_aq.enqueue_options_t; 
   Message_properties    dbms_aq.message_properties_t; 
   myid RAW(16);
   msg scott.toy_type;
BEGIN
	msg := scott.toy_type('banny rabit', 'brown');
        message_properties.priority := 30; 
	SYS.DBMS_AQ.ENQUEUE (
	queue_name => 'scott.toy_queue',
        enqueue_options => Enqueue_options, 
        message_properties         => message_properties, 
	payload=> msg,
	msgid => myid);
        commit;
END;
/
show errors

